//
//  MainWindowController.m
//  MagicButton
//
//  Created by Andrew Choi on 22/01/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "MainWindowController.h"

#define EXCEPTION(REASON) [NSException exceptionWithName:[NSString stringWithCString:__func__] reason:REASON userInfo:nil];

@implementation MainWindowController

- (void)awakeFromNib
{
  Py_Initialize();

  PyObject *sysModule = PyImport_ImportModule("sys");
  if (!sysModule)
    @throw EXCEPTION(@"Fail to open module \"sys\"");

  PyObject *sysModuleDict = PyModule_GetDict(sysModule);
  PyObject *pathObject = PyDict_GetItemString(sysModuleDict, "path");
  if (!pathObject)
    @throw EXCEPTION(@"Fail to find object \"sys.path\"");

  /* Add main bundle path one to Python search path (sys.path).  */
  NSString *bundlePath = [[[NSBundle mainBundle] bundlePath] stringByAppendingString:@"/Contents/Resources"];
  PyObject *result = PyObject_CallMethod(pathObject, "insert", "(is)", 0, [bundlePath cStringUsingEncoding:CFStringConvertEncodingToNSStringEncoding(CFStringGetSystemEncoding())]);
  /* sysModuleDict and pathObject are borrowed references.  */
  Py_DECREF(sysModule);
  Py_DECREF(result);

  TOEModule = PyImport_ImportModule("TOE");
  if (!TOEModule)
    @throw EXCEPTION(@"Fail to open TOE module");

  TOEModuleDict = PyModule_GetDict(TOEModule);
  
  PyObject *initializeFunc = PyDict_GetItemString(TOEModuleDict, "Initialize");
  if (!initializeFunc || !PyCallable_Check(initializeFunc))
    @throw EXCEPTION(@"No callable function \"Initialize\" in module");

  PyObject *initResult = PyObject_CallFunction(initializeFunc, "()");

  if (!initResult)
    @throw EXCEPTION(@"Function \"Initialize\" fails");
  
  actionModule = PyImport_ImportModule("action");
  if (!actionModule)
    @throw EXCEPTION(@"Fail to open action module");
  
  actionModuleDict = PyModule_GetDict(actionModule);  
}

- (void)dealloc;
{
  PyObject *terminateFunc = PyDict_GetItemString(TOEModuleDict, "Terminate");
  if (!terminateFunc || !PyCallable_Check(terminateFunc))
    @throw EXCEPTION(@"No callable function \"Terminate\" in module");
  
  PyObject *termResult = PyObject_CallFunction(terminateFunc, "()");
  
  if (!termResult)
    @throw EXCEPTION(@"Function \"Terminate\" fails");
  
  Py_Finalize();
  
  [super dealloc];
}

- (IBAction)magicButtonClicked:(id)sender
{
  //NSLog(@"Magic Button Clicked");
  
  PyObject *buttonFunc = PyDict_GetItemString(actionModuleDict, "button");
  if (!buttonFunc || !PyCallable_Check(buttonFunc))
    @throw EXCEPTION(@"No callable function \"button\" in action module");
  
  PyObject *buttonResult = PyObject_CallFunction(buttonFunc, "()");
  
  if (!buttonResult)
    @throw EXCEPTION(@"Function \"button\" fails");  
}

@end
